//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------


#include "text.h"

u8 strlen(const u8 *str){
    
    const u8 *s;
    
    for (s = str; *s; ++s);

    return (s - str);
}

void drawNumber(u16 aNumber, u8 length, u8 xPos, u8 yPos, u8 distance, u8* buffer){

	u8 *pvideo = cpct_getScreenPtr(buffer, xPos, yPos);

    u8 str[6];
    u8 zeros;
    u8 x = 0;

    uitoa(aNumber, str);
    zeros = length - strlen(str);

    while(x<zeros){

    	cpct_drawSprite(G_marcador, pvideo, MARCADOR_W, MARCADOR_H);
    	pvideo += MARCADOR_W + distance;
    	x++;

    }

    x = 0;

    while(x < length - zeros){

        cpct_drawSprite(G_marcador + (str[x] - 48), pvideo, MARCADOR_W, MARCADOR_H);
        pvideo += MARCADOR_W + distance;
        x++;
    }


}


void drawText(u8 text[], u8 yPos){

    u8* pvideo = cpct_getScreenPtr(g_scrbuffers[1], 40 - ((strlen(text) * FONT_W) / 2), yPos);
    u8 character;
    u8 x = 0;

    character = text[x];

    do{

        //NUMEROS
        if(character >= 48 && character <= 57){

            cpct_drawSpriteMaskedAlignedTable(G_number + (character - 48) * FONT_W * FONT_H, pvideo, FONT_W, FONT_H, g_transparencyMaskTable);
        }

        else if(character != 32){ //32 = SPACE

        	cpct_drawSpriteMaskedAlignedTable(G_font + (character - 64) *  FONT_W * FONT_H, pvideo, FONT_W, FONT_H, g_transparencyMaskTable);
        }

        pvideo += FONT_W;

        character = text[++x];

    } while(character != '\0');


}
